#ifndef _MOTIONMANAGER_H_
#define _MOTIONMANAGER_H_

#include "main.h"
#include <string>
#include <unordered_map>

// --------[Vǂݍ݃NX
class CSceneModel;
class CMotionManager
{
public:
	typedef struct
	{
		float move;					// ړ
		float jump;					// Wv
		float rad;					// a
		int numParts;				// p[c (PARTSNX̑)
	}CHARA;

	// p[cꎞǂݎp\
	typedef struct
	{
		int index, parent;
	}PARTS;

	// p[cW
	typedef struct
	{
		D3DXVECTOR3 pos;			// W
		D3DXVECTOR3 rot;			// ]
		int index;					// p[cCfbNX

		D3DXVECTOR3 posParFlame;	// 1t[ɈړW
		D3DXVECTOR3 rotParFlame;	// 1t[ɉ]
	}MOVEPARTS;

	// L[
	typedef struct
	{
		int	flame;					// st[
		int index;					// L[CfbNX

		std::list<MOVEPARTS*> lisMoveParts;	// ړp[c
	}KEY;

	// [V
	typedef struct
	{
		bool loop;					// JԂ̗L
		int numKey;					// L[ (MOTIONKEY\̂̑)
		int index;					// [VCfbNX

		std::list<KEY*> lisKey;		// L[
	}MOTION;

	// RXgN^, fXgN^
	CMotionManager() {}
	~CMotionManager() {}

	// 
	static void LoadMotion(const std::string &strFilePass);	// [V}l[Wɒǉ

	// S
	static void ReleaseAll(void);							// fS

	// 擾
	CMotionManager *GetMotionManager(std::string strName);	// [V}l[W̎擾
	MOTION *GetMotion(int index);							// [V̎擾
	KEY *GetKeyList(MOTION *pMotion, int index);			// Key̎擾
	MOVEPARTS *GetMovePartsList(KEY *pKey, int index);		// MoveParts̎擾

private:
	// o֐
	static bool seekSrcData(char *texName);	// w蕶܂œǂݐi߂
	static int getNumInt(void);				// int̒lԂ
	static float getNumFloat(void);			// float̒lԂ
	static char *getChar(void);				// char̃|C^Ԃ
	
	// oϐ
	static int m_fileSize;					// t@C
	static int m_currentSrc;				// ݈ʒu
	static char *m_pSrcData;				// i[p|C^
	static char m_buf[MAX_PATH];			// obt@(ꎞi[p)

	int m_numModel;							// f
	CHARA m_chara;							// LN^[
	std::vector<CSceneModel*> m_vecModel;	// p[c
	std::list<MOTION*> m_lisMotion;			// [V
	static std::unordered_map<std::string, CMotionManager*> m_umapMotionManager;	// [V}l[W
};

#endif